#/usr/bin/python
# -*- coding: utf-8 -*-


__author__ = 'yarnaid'

from agn_periodics import utils
import numpy
# import copy
from scipy import interpolate

conf = utils.load_config()


default_params = dict()
load_params = default_params
dump_params = default_params


class AbstractData(object):
    time_var = None
    values = None
    errors = None
    n = None
    __interpolated__ = False

    def __init__(self, file_name=None):
        if file_name is not None:
            self.load(file_name)

    def load(self, file_name):
        print self.__name__ + ' load method stub'

    def dump(self, file_name):
        # TODO: all data to one variable
        # data = None
        # numpy.savetxt(file_name, data, **dump_params)
        print self.__name__ + ' dump method stub'

    def __interpolate__(self):
        if self.__interpolated__:
            return
        x = self.time_var
        y = self.values
        self.n = self.n * 10
        tck = interpolate.splrep(x, y)
        x_new = numpy.linspace(min(x), max(x), self.n)
        y_new = interpolate.splev(x_new, tck)
        self.time_var = x_new
        self.values = y_new
        self.__interpolated__ = True



class TimeRow(AbstractData):
    X_q = None

    def load(self, file_name=None, row=None, time=None):
        res = self
        if file_name is not None:
            self.load_file(file_name)
        elif row is not None and time is not None:
            self.load_arrays(row, time)
        else:
            raise 'Cannot load data'
        self.__interpolate__()
        res = TimeRow()
        return res

    def load_file(self, file_name):
        self.raw_data = numpy.loadtxt(file_name, **load_params)
        self.time_var = self.raw_data[:, 0] + self.raw_data[:, 1] / 12.
        self.values = self.raw_data[:, 4]
        self.n = len(self.time_var)

    def load_arrays(self, row, time):
        if len(row) != len(time):
            raise ValueError('row and time must have the same length')
        self.raw_data = numpy.asarray(row)
        self.time_var = numpy.asarray(time)
        self.values = numpy.asarray(row)
        self.n = len(self.time_var)

    def __str__(self):
        res = str()
        if self.errors is not None:
            get_line = lambda i: str(self.time_var[i]) + ' ' + str(
                self.values[i]) + ' ' + str(self.errors[i]) + '\n'
        else:
            get_line = lambda i: str(
                self.time_var[i]) + ' ' + str(self.values[i]) + '\n'

        for i in xrange(self.n):
            res += get_line(i)

        return res
